% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentence_similarity.R
\name{sentence_similarity}
\alias{sentence_similarity}
\title{Sentiment Analysis Scores}
\usage{
sentence_similarity(
  text,
  comparison_text,
  transformer = c("all_minilm_l6"),
  device = c("auto", "cpu", "cuda"),
  preprocess = FALSE,
  keep_in_env = TRUE,
  envir = 1
)
}
\arguments{
\item{text}{Character vector or list.
Text in a vector or list data format}

\item{comparison_text}{Character vector or list.
Text in a vector or list data format}

\item{transformer}{Character.
Specific sentence similarity transformer
to be used.
Defaults to \code{"all_minilm_l6"} (see \href{https://huggingface.co/sentence-transformers/all-MiniLM-L6-v2}{huggingface})

Also allows any sentence similarity models with a pipeline
from \href{https://huggingface.co/models?pipeline_tag=sentence-similarity}{huggingface}
to be used by using the specified name (e.g., \code{"typeform/distilbert-base-uncased-mnli"}; see Examples)}

\item{device}{Character.
Whether to use CPU or GPU for inference.
Defaults to \code{"auto"} which will use
GPU over CPU (if CUDA-capable GPU is setup).
Set to \code{"cpu"} to perform over CPU}

\item{preprocess}{Boolean.
Should basic preprocessing be applied?
Includes making lowercase, keeping only alphanumeric characters,
removing escape characters, removing repeated characters,
and removing white space.
Defaults to \code{FALSE}.
Transformers generally are OK without preprocessing and handle
many of these functions internally, so setting to \code{TRUE}
will not change performance much}

\item{keep_in_env}{Boolean.
Whether the classifier should be kept in your global environment.
Defaults to \code{TRUE}.
By keeping the classifier in your environment, you can skip
re-loading the classifier every time you run this function.
\code{TRUE} is recommended}

\item{envir}{Numeric.
Environment for the classifier to be saved for repeated use.
Defaults to the global environment}
}
\value{
Returns a \emph{n} x \emph{m} similarity matrix where \emph{n} is length of \code{text} and \emph{m} is the length of \code{comparison_text}
}
\description{
Uses sentiment analysis pipelines from \href{https://huggingface.co}{huggingface}
to compute probabilities that the text corresponds to the specified classes
}
\examples{
# Load data
data(neo_ipip_extraversion)

# Example text
text <- neo_ipip_extraversion$friendliness[1:5]

\dontrun{
# Example with defaults
sentence_similarity(
 text = text, comparison_text = text
)

# Example with model from 'sentence-transformers'
sentence_similarity(
 text = text, comparison_text = text,
 transformer = "sentence-transformers/all-mpnet-base-v2"
)

}

}
\author{
Alexander P. Christensen <alexpaulchristensen@gmail.com>
}
