% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LmME.R
\name{confint.LmME}
\alias{confint.LmME}
\title{Confidence intervals for LmME model parameters}
\usage{
\method{confint}{LmME}(
  object,
  parm = NULL,
  level = 0.95,
  as.lm = FALSE,
  pargroup = c("all", "fixef", "ranef"),
  type = c("Wald", "wald", "profile"),
  estimate = FALSE,
  ...
)
}
\arguments{
\item{object}{An \code{LmME} object.}

\item{parm}{Names of the parameters to extract.}

\item{level}{Confidence level.}

\item{as.lm}{Logical. If \code{TRUE}, return results consistent with the normal linear
mixed model parametrization.}

\item{pargroup}{The name of the parameter group to extract. With \code{as.lm = FALSE},
the available options are described in \code{confint.tramME}. When \code{as.lm = TRUE},
the following options are available:
\itemize{
  \item all: Fixed effects and variance components parameters.
  \item fixef: Fixed effects parameters (including FE parameters of the smooth terms).
  \item ranef: Variance components parameters (including the smoothing parameters of
    the random effects).
}}

\item{type}{Type of the CI: either Wald or profile.}

\item{estimate}{Logical, add the point estimates in a thrid column.}

\item{...}{Optional parameters passed to \code{confint.tramME}}
}
\value{
A matrix with lower and upper bounds.
}
\description{
Confidence intervals for model parameters on their original scale,
optionally consistent with the linear mixed-model specification.
When \code{as.lm = TRUE}, only Wald CIs are available.
}
\examples{
data("sleepstudy", package = "lme4")
fit <- LmME(Reaction ~ Days + (Days | Subject), data = sleepstudy)
confint(fit) ## transformation model parametrization
confint(fit, as.lm = TRUE) ## LMM parametrization
confint(fit, as.lm = TRUE, pargroup = "fixef", estimate = TRUE)
confint(fit, as.lm = TRUE, parm = "(Sigma)") ## error SD
}
