% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapperTraj.R
\name{wrapperTraj}
\alias{wrapperTraj}
\title{Wrapper Function to Perform Trajectory Analysis}
\usage{
wrapperTraj(Data, ID = FALSE)
}
\arguments{
\item{Data}{Data frame containing trajectory data.
Each line should contain sequential observations. See details and help file for the \code{\link[traj]{step1measures}} function.}

\item{ID}{Logical. Set to \code{FALSE} if the first column of \code{Data} corresponds to an \code{ID} variable. Defaults to \code{FALSE}.}
}
\value{
The result is a \code{traj} object. Details can be found in the 'Value' section of \code{\link[traj]{step3clusters}}.
}
\description{
Run three steps of trajectory analysis with default parameters.
}
\details{
The function runs the full three step trajectory analysis and returns a \code{traj} object.
It will execute \code{\link[traj]{step1measures}}, \code{\link[traj]{step2factors}} and \code{\link[traj]{step3clusters}}
sequentially with their default parameters. The result of \code{step3clusters} will be returned. Details regarding
the \code{data} and the \code{time} arguments are found in the 'Details' section of \code{\link[traj]{step1measures}}.
}
\examples{
\dontrun{
# Setup data
data = example.data$data

# Run clustering wrapper function
wt = wrapperTraj(data, ID = TRUE)

# Display and plot "traj" object
wt

summary(wt)

plot(wt)
}


}
\author{
Marie-Pierre Sylvestre, Dan Vatnik

marie-pierre.sylvestre@umontreal.ca
}
