% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variables.R
\name{categorical.predictive.power}
\alias{categorical.predictive.power}
\title{categorical.predictive.power}
\usage{
categorical.predictive.power(
  data,
  predict.variable,
  variable.to.compare,
  ylab = "",
  xlab = "",
  main = paste("Variable Distribution", variable.to.compare, "according to",
    predict.variable),
  col = NA
)
}
\arguments{
\item{data}{A data frame.}

\item{predict.variable}{Character type. The name of the variable to predict. This name must be part of the columns of the data frame.}

\item{variable.to.compare}{Character type. The name of the categorical variable to compare. This name must be part of the columns of the data frame.}

\item{ylab}{A character string that describes the y-axis on the graph.}

\item{xlab}{A character string that describes the x-axis on the graph.}

\item{main}{Character type. The main title of the chart.}

\item{col}{A vector that specifies the colors of the categories of the variable to predict.}
}
\value{
A ggplot object.
}
\description{
Function that graphs the distribution of individuals and shows their category according to a categorical variable.
}
\note{
With this function we can analyze the predictive power of a categorical variable.
}
\examples{

cars <- datasets::mtcars
cars$cyl <- as.factor(cars$cyl)
cars$vs <- as.factor(cars$vs)
categorical.predictive.power(cars,"vs","cyl")

}
\seealso{
\code{\link[ggplot2]{ggplot}}
}
