% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train.R
\name{train.glmnet}
\alias{train.glmnet}
\title{train.glmnet}
\usage{
train.glmnet(
  formula,
  data,
  standardize = TRUE,
  alpha = 1,
  family = "multinomial",
  cv = TRUE,
  ...
)
}
\arguments{
\item{formula}{A formula of the form groups ~ x1 + x2 + ... That is, the response is the grouping factor and the right hand side specifies the (non-factor) discriminators.}

\item{data}{An optional data frame, list or environment from which variables specified in formula are preferentially to be taken.}

\item{standardize}{Logical flag for x variable standardization, prior to fitting the model sequence.
The coefficients are always returned on the original scale. Default is standardize=TRUE.
If variables are in the same units already, you might not wish to standardize.
See details below for y standardization with family="gaussian".}

\item{alpha}{The elasticnet mixing parameter. alpha=1 is the lasso penalty, and alpha=0 the ridge penalty.}

\item{family}{Either a character string representing one of the built-in families, or else a glm() family object.
For more information, see Details section below or the documentation for response type (above).}

\item{cv}{True or False. Perform cross-validation to find the best value of the penalty parameter lambda and save this value in the model.
This value could be used in predict() function.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A object glmnet.prmdt with additional information to the model that allows to homogenize the results.
}
\description{
Provides a wrapping function for the \code{\link[glmnet]{glmnet}}.
}
\note{
The parameter information was taken from the original function \code{\link[glmnet]{glmnet}}.
}
\examples{

len <- nrow(iris)
sampl <- sample(x = 1:len,size = len*0.20,replace = FALSE)
ttesting <- iris[sampl,]
ttraining <- iris[-sampl,]
model.glmnet <- train.glmnet(Species~.,ttraining)
prediction <- predict(model.glmnet,ttesting)
prediction
general.indexes(ttesting,prediction)

}
\seealso{
The internal function is from package \code{\link[glmnet]{glmnet}}.
}
