% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general.indexes.R
\name{general.indexes}
\alias{general.indexes}
\title{general.indexes}
\usage{
general.indexes(newdata, prediction, mc = NULL)
}
\arguments{
\item{newdata}{matrix or data frame of test data.}

\item{prediction}{a prmdt prediction object.}

\item{mc}{(optional) a matrix for calculating the indices. If mc is entered as parameter newdata and prediction are not necessary.}
}
\value{
A list with the confusion matrix, overall accuracy, overall error and the category accuracy. The class of this list is indexes.prmdt
}
\description{
Calculates the confusion matrix, overall accuracy, overall error and the category accuracy
}
\examples{

data("iris")

n <- seq_len(nrow(iris))
.sample <- sample(n, length(n) * 0.75)
data.train <- iris[.sample,]
data.test <- iris[-.sample,]

modelo.knn <- train.knn(Species~., data.train)
modelo.knn
prob <- predict(modelo.knn, data.test, type = "prob")
prob
prediccion <- predict(modelo.knn, data.test, type = "class")
prediccion
general.indexes(data.test, prediccion)

}
