% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train.R
\name{train.glm}
\alias{train.glm}
\title{train.glm}
\usage{
train.glm(formula, data, family = binomial, weights, subset, na.action,
  start = NULL, etastart, mustart, offset, control = list(...),
  model = TRUE, method = "glm.fit", x = FALSE, y = TRUE,
  singular.ok = TRUE, contrasts = NULL, ...)
}
\arguments{
\item{formula}{an object of class "formula" (or one that can be coerced to that class): a symbolic description of the model to be fitted. The details of model specification are given under ‘Details’.}

\item{data}{an optional data frame, list or environment (or object coercible by as.data.frame to a data frame) containing the variables in the model. If not found in data, the variables are taken from environment(formula), typically the environment from which glm is called.}

\item{family}{a description of the error distribution and link function to be used in the model. For glm this can be a character string naming a family function, a family function or the result of a call to a family function. For glm.fit only the third option is supported. (See family for details of family functions.)}

\item{weights}{an optional vector of ‘prior weights’ to be used in the fitting process. Should be NULL or a numeric vector.}

\item{subset}{an optional vector specifying a subset of observations to be used in the fitting process.}

\item{na.action}{a function which indicates what should happen when the data contain NAs. The default is set by the na.action setting of options, and is na.fail if that is unset. The ‘factory-fresh’ default is na.omit. Another possible value is NULL, no action. Value na.exclude can be useful.}

\item{start}{starting values for the parameters in the linear predictor.}

\item{etastart}{starting values for the linear predictor.}

\item{mustart}{starting values for the vector of means.}

\item{offset}{this can be used to specify an a priori known component to be included in the linear predictor during fitting. This should be NULL or a numeric vector of length equal to the number of cases. One or more offset terms can be included in the formula instead or as well, and if more than one is specified their sum is used. See model.offset.}

\item{control}{a list of parameters for controlling the fitting process. For glm.fit this is passed to glm.control.}

\item{model}{a logical value indicating whether model frame should be included as a component of the returned value.}

\item{method}{the method to be used in fitting the model. The default method "glm.fit" uses iteratively reweighted least squares (IWLS): the alternative "model.frame" returns the model frame and does no fitting.
User-supplied fitting functions can be supplied either as a function or a character string naming a function, with a function which takes the same arguments as glm.fit. If specified as a character string it is looked up from within the stats namespace.}

\item{x, y}{For glm: logical values indicating whether the response vector and model matrix used in the fitting process should be returned as components of the returned value.
For glm.fit: x is a design matrix of dimension n * p, and y is a vector of observations of length n.}

\item{singular.ok}{logical; if FALSE a singular fit is an error.}

\item{contrasts}{an optional list. See the contrasts.arg of model.matrix.default.}

\item{...}{For glm: arguments to be used to form the default control argument if it is not supplied directly.
For weights: further arguments passed to or from other methods.}
}
\value{
A object glm.prmdt with additional information to the model that allows to homogenize the results.
}
\description{
Provides a wrapping function for the \code{\link[stats]{glm}}
}
\examples{

data("Puromycin")

n <- seq_len(nrow(Puromycin))
.sample <- sample(n, length(n) * 0.65)
data.train <- Puromycin[.sample,]
data.test <- Puromycin[-.sample,]

modelo.glm <- train.glm(state~., data.train)
modelo.glm
prob <- predict(modelo.glm, data.test , type = "prob")
prob
prediccion <- predict(modelo.glm, data.test , type = "class")
prediccion
confusion.matrix(data.test, prediccion)

}
\seealso{
The internal function is from package \code{\link[stats]{glm}}.

The internal function is from package \code{\link[stats]{glm}}.
}
