% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{newMriImageFromDicomDirectory}
\alias{newMriImageFromDicomDirectory}
\alias{newMriImageFromFile}
\alias{writeMriImageToFile}
\alias{newMriImageByExtraction}
\alias{extractDataFromMriImage}
\alias{newMriImageByReordering}
\alias{newMriImageByTrimming}
\alias{newMriImageWithData}
\alias{newMriImageWithSimpleFunction}
\alias{newMriImageWithBinaryFunction}
\alias{newMriImageByMasking}
\alias{newMriImageByThresholding}
\alias{newDicomMetadataFromFile}
\alias{removeImageFilesWithName}
\title{Deprecated functions}
\usage{
newMriImageFromDicomDirectory(dicomDir, readDiffusionParams = FALSE,
  untileMosaics = TRUE)

newMriImageFromFile(fileName, fileType = NULL, metadataOnly = FALSE,
  volumes = NULL, sparse = FALSE, mask = NULL, reorder = TRUE)

writeMriImageToFile(image, fileName = NULL, fileType = NA,
  overwrite = TRUE)

newMriImageByExtraction(image, dim, loc)

extractDataFromMriImage(image, dim, loc)

newMriImageByReordering(image)

newMriImageByTrimming(image, clearance = 4)

newMriImageWithData(data, templateImage = nilObject(), imageDims = NA,
  voxelDims = NA, voxelDimUnits = NA, origin = NA, tags = NA)

newMriImageWithSimpleFunction(image, fun, ...)

newMriImageWithBinaryFunction(image1, image2, fun, ...)

newMriImageByMasking(image, mask)

newMriImageByThresholding(image, level, defaultValue = 0)

newDicomMetadataFromFile(fileName, checkFormat = TRUE,
  dictionary = NULL, stopTag = NULL, ignoreTransferSyntax = FALSE)

removeImageFilesWithName(fileName)
}
\arguments{
\item{dicomDir}{Character vector of length one giving the name of a
directory containing DICOM files.}

\item{readDiffusionParams}{Logical value. Should diffusion MRI parameters
(b-values and gradient directions) be retrieved from the files if
possible?}

\item{untileMosaics}{Logical value. Should Siemens mosaic images be
converted into 3D volumes? This may occasionally be performed in error,
which can be prevented by setting this value to \code{FALSE}.}

\item{fileName}{File names, with or without appropriate extension.}

\item{fileType}{A character vector of length one, giving the file type
required or expected. If this option is missing, the file type used for
writing images will be taken from the \code{tractorFileType} option. See
Details.}

\item{metadataOnly}{Logical value: if \code{TRUE}, only metadata are read
into the object.}

\item{volumes}{An optional integer vector specifying a subset of volumes to
read (generally to save memory). If given, only the requested volumes in
the 4D file will be read.}

\item{sparse}{Logical value: should the image data be stored in a
\code{\linkS4class{SparseArray}} object?}

\item{mask}{An array whose nonzero voxel locations will be masked in.}

\item{reorder}{Logical value: should the image data be reordered to LAS?
This is recommended in most circumstances.}

\item{image, image1, image2}{\code{MriImage} objects.}

\item{overwrite}{Logical value: overwrite an existing image file? For
\code{writeImageFile}, an error will be raised if there is an existing
file and this is set to FALSE.}

\item{dim}{The dimension and location along that dimension for which
data should be extracted.}

\item{loc}{The dimension and location along that dimension for which
data should be extracted.}

\item{clearance}{The number of voxels' clearance left around a trimmed
image.}

\item{data}{An array of pixel/voxel data.}

\item{templateImage}{An optional \code{MriImage} object, to be used as a
metadata template.}

\item{imageDims}{Metadata for
the new image object. These values override any from the metadata object
or data array. See \code{\linkS4class{MriImage}} class documentation for
details.}

\item{voxelDims}{Metadata for
the new image object. These values override any from the metadata object
or data array. See \code{\linkS4class{MriImage}} class documentation for
details.}

\item{voxelDimUnits}{Metadata for
the new image object. These values override any from the metadata object
or data array. See \code{\linkS4class{MriImage}} class documentation for
details.}

\item{origin}{Metadata for
the new image object. These values override any from the metadata object
or data array. See \code{\linkS4class{MriImage}} class documentation for
details.}

\item{tags}{Metadata for
the new image object. These values override any from the metadata object
or data array. See \code{\linkS4class{MriImage}} class documentation for
details.}

\item{fun}{A function, of the appropriate arity.}

\item{...}{Additional argument to \code{fun}.}

\item{level}{The threshold level, below which all voxels will be reset.}

\item{defaultValue}{The value to reset to.}

\item{checkFormat}{If \code{TRUE}, the function will check for the magic
string \code{"DICM"} at byte offset 128. This string should be present,
but in reality not all files contain it.}

\item{dictionary}{Ignored.}

\item{stopTag}{An integer vector giving the group and element numbers (in
that order) of a DICOM tag, or \code{NULL}. If not \code{NULL}, the
function will stop parsing the DICOM file if the specified tag is
encountered. This can be used to speed up the process if a specific tag is
required.}

\item{ignoreTransferSyntax}{If \code{TRUE}, any transfer syntax stored in
the file will be ignored, and the code will try to deduce the transfer
syntax using heuristics. This may occasionally be necessary for awkward
DICOM files, but is not generally recommended.}
}
\description{
These functions are deprecated, generally in favour of more succint
alternatives.
}
