% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Generics.R, R/PlotWrapper.R
\docType{methods}
\name{graphSys}
\alias{graphSys}
\alias{graphSys,PlotFeatureSet-method}
\title{Accessor method for PlotFeatureSet "package" slot.}
\usage{
graphSys(object)

\S4method{graphSys}{PlotFeatureSet}(object)
}
\arguments{
\item{object}{An object of (super)class PlotFeatureSet.}
}
\value{
A character vector representing the originating R package of the plot object, i.e. base, ggplot, or lattice.
}
\description{
Retrieve the graphics system from a PlotFeatureSet object
}
\examples{
library(ggplot2)
plt = qplot(mtcars$mpg, mtcars$cyl)
fs = makeFeatureSet(plt)
graphSys(fs)
}
