% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputeSpeeds.R
\name{imputeSpeeds}
\alias{imputeSpeeds}
\title{Impute speeds.}
\usage{
imputeSpeeds(sessionData, fromDistances = TRUE, lgap = 30, lskip = 5,
  m = 11, cycling = FALSE, units = NULL)
}
\arguments{
\item{sessionData}{A multivariate \code{\link[zoo]{zoo}} object with
observations of either distance or speed (named Distance or Speed,
respectively).}

\item{fromDistances}{Logical. Should the speeds be calculated from the distance recordings
instead of taken from the speed recordings directly?}

\item{lgap}{Time in seconds corresponding to the minimal sampling rate.}

\item{lskip}{Time in seconds between the last observation before a small break
and the first imputed speed or the last imputed speed and the first
observation after a small break.}

\item{m}{Number of imputed observations in each small break.}

\item{cycling}{Logical. Are the data from a cycling session? If \code{TRUE}, power is
imputed with \code{0}, else with \code{NA}.}

\item{units}{Units of measurement.}
}
\value{
A multivariate \code{\link[zoo]{zoo}} object with imputed observations:
    0 for speed, last known position for latitude, longitude and altitude,
    NA for all other variables. Distances are calculated based on speeds after imputation.
}
\description{
Impute speeds of 0 during small breaks within a session.
}
\references{
Kosmidis, I., and Passfield, L. (2015). Linking the Performance of
    Endurance Runners to Training and Physiological Effects via Multi-Resolution
    Elastic Net. \emph{ArXiv e-print} arXiv:1506.01388.
    Frick, H., Kosmidis, I. (2017). trackeR: Infrastructure for Running and Cycling Data from GPS-Enabled Tracking Devices in R. \emph{Journal of Statistical Software}, \bold{82}(7), 1--29. doi:10.18637/jss.v082.i07
}
