% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allClasses.R, R/methods-TxpResultList.R
\docType{class}
\name{TxpResultList-class}
\alias{TxpResultList-class}
\alias{TxpResultList}
\alias{duplicated,TxpResultList-method}
\alias{as.TxpResultList}
\title{List of TxpResult objects}
\usage{
TxpResultList(...)

\S4method{duplicated}{TxpResultList}(x)

as.TxpResultList(x)
}
\arguments{
\item{...}{\link{TxpResult} object to create \code{TxpResultList} object}

\item{x}{\code{TxpResultList} object}
}
\description{
Extension of \link[S4Vectors:SimpleList-class]{S4Vectors::SimpleList} that holds only \link{TxpResult}
objects.
}
\examples{
## Load example dataset & model; see ?TxpModel for building model objects
data(txp_example_input, package = "toxpiR")
data(txp_example_model, package = "toxpiR")

## Calculate scores for list of models; returns TxpResultList object
txpCalculateScores(model = TxpModelList(m1 = txp_example_model, 
                                        m2 = txp_example_model), 
                   input = txp_example_input, 
                   id.var = "name")
resLst <- txpCalculateScores(model = list(m1 = txp_example_model, 
                                          m2 = txp_example_model), 
                             input = txp_example_input, 
                             id.var = "name")

## duplicated
duplicated(resLst)

## Coercion
as(list(resLst[[1]], resLst[[2]]), "TxpResultList")
as.TxpResultList(list(res1 = resLst[[1]], res2 = resLst[[2]]))

as(resLst[[1]], "TxpResultList")
as.TxpResultList(resLst[[1]])
}
\seealso{
\link{TxpResult}, \link{txpCalculateScores}
}
