% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend-common.R
\name{transform_to_tensor}
\alias{transform_to_tensor}
\title{Convert an audio object into a tensor}
\usage{
transform_to_tensor(
  audio,
  out = NULL,
  normalization = TRUE,
  channels_first = TRUE
)
}
\arguments{
\item{audio}{(numeric or Wave): A numeric vector or Wave object, usually from \link[tuneR:readMP3]{tuneR::readMP3} or \link[tuneR:readWave]{tuneR::readWave}.}

\item{out}{(Tensor): An optional output tensor to use instead of creating one. (Default: \code{NULL})}

\item{normalization}{(bool, float or function): Optional normalization.
If boolean \code{TRUE}, then output is divided by \code{2^(bits-1)}.
If \code{bits} info is not available it assumes the input is signed 32-bit audio.
If \code{numeric}, then output is divided by that number.
If \code{function}, then the output is passed as a parameter to the given function,
then the output is divided by the result. (Default: \code{TRUE})}

\item{channels_first}{(bool): Set channels first or length first in result. (Default: \code{TRUE})}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{list(Tensor, int): An output tensor of size `[C x L]` or `[L x C]` where
    L is the number of audio frames and
    C is the number of channels.
    An integer which is the sample rate of the audio (as listed in the metadata of the file)
}\if{html}{\out{</div>}}
}
\description{
Converts a tuneR Wave object or numeric vector into a \code{torch_tensor} of shape (Channels x Samples).
Convert Audio Object to Tensor.
}
\details{
If audio is a numeric vector, attributes "channels" and "sample_rate" will be used if exists.
Numeric vectors returned from \link[av:read_audio]{av::read_audio_bin} have both attributes by default.
}
