% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linalg.R
\name{linalg_slogdet}
\alias{linalg_slogdet}
\title{Computes the sign and natural logarithm of the absolute value of the determinant of a square matrix.}
\usage{
linalg_slogdet(A)
}
\arguments{
\item{A}{(Tensor): tensor of shape \verb{(*, n, n)} where \code{*} is zero or more batch dimensions.}
}
\value{
A list \verb{(sign, logabsdet)}.
\code{logabsdet} will always be real-valued, even when \code{A} is complex.
\code{sign} will have the same dtype as \code{A}.
}
\description{
For complex \code{A}, it returns the angle and the natural logarithm of the modulus of the
determinant, that is, a logarithmic polar decomposition of the determinant.
Supports input of float, double, cfloat and cdouble dtypes.
Also supports batches of matrices, and if \code{A} is a batch of matrices then
the output has the same batch dimensions.
}
\section{Notes}{

\itemize{
\item The determinant can be recovered as \code{sign * exp(logabsdet)}.
\item When a matrix has a determinant of zero, it returns \verb{(0, -Inf)}.
}
}

\examples{
if (torch_is_installed()) {
a <- torch_randn(3, 3)
linalg_slogdet(a)
}
}
\seealso{
Other linalg: 
\code{\link{linalg_cholesky_ex}()},
\code{\link{linalg_cholesky}()},
\code{\link{linalg_det}()},
\code{\link{linalg_eigh}()},
\code{\link{linalg_eigvalsh}()},
\code{\link{linalg_eigvals}()},
\code{\link{linalg_eig}()},
\code{\link{linalg_householder_product}()},
\code{\link{linalg_inv_ex}()},
\code{\link{linalg_inv}()},
\code{\link{linalg_lstsq}()},
\code{\link{linalg_matrix_norm}()},
\code{\link{linalg_matrix_power}()},
\code{\link{linalg_matrix_rank}()},
\code{\link{linalg_multi_dot}()},
\code{\link{linalg_norm}()},
\code{\link{linalg_pinv}()},
\code{\link{linalg_qr}()},
\code{\link{linalg_solve}()},
\code{\link{linalg_svdvals}()},
\code{\link{linalg_svd}()},
\code{\link{linalg_tensorinv}()},
\code{\link{linalg_tensorsolve}()},
\code{\link{linalg_vector_norm}()}
}
\concept{linalg}
