% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-init.R
\name{nn_init_dirac_}
\alias{nn_init_dirac_}
\title{Dirac initialization}
\usage{
nn_init_dirac_(tensor, groups = 1)
}
\arguments{
\item{tensor}{a {3, 4, 5}-dimensional \code{torch.Tensor}}

\item{groups}{(optional) number of groups in the conv layer (default: 1)}
}
\description{
Fills the {3, 4, 5}-dimensional input \code{Tensor} with the Dirac
delta function. Preserves the identity of the inputs in \code{Convolutional}
layers, where as many input channels are preserved as possible. In case
of groups>1, each group of channels preserves identity.
}
\examples{
if (torch_is_installed()) {
\dontrun{
w <- torch_empty(3, 16, 5, 5)
nn_init_dirac_(w)
}

}
}
