% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R
\name{torch_norm}
\alias{torch_norm}
\title{Norm}
\arguments{
\item{input}{(Tensor) the input tensor}

\item{p}{(int, float, inf, -inf, 'fro', 'nuc', optional) the order of norm. Default: \code{'fro'}        The following norms can be calculated:        =====  ============================  ==========================        ord    matrix norm                   vector norm        =====  ============================  ==========================        None   Frobenius norm                2-norm        'fro'  Frobenius norm                --        'nuc'  nuclear norm                  --        Other  as vec norm when dim is None  sum(abs(x)\strong{ord)}(1./ord)        =====  ============================  ==========================}

\item{dim}{(int, 2-tuple of ints, 2-list of ints, optional) If it is an int,        vector norm will be calculated, if it is 2-tuple of ints, matrix norm        will be calculated. If the value is None, matrix norm will be calculated        when the input tensor only has two dimensions, vector norm will be        calculated when the input tensor only has one dimension. If the input        tensor has more than two dimensions, the vector norm will be applied to        last dimension.}

\item{keepdim}{(bool, optional) whether the output tensors have \code{dim}        retained or not. Ignored if \code{dim} = \code{None} and        \code{out} = \code{None}. Default: \code{False}}

\item{out}{(Tensor, optional) the output tensor. Ignored if        \code{dim} = \code{None} and \code{out} = \code{None}.}

\item{dtype}{(\code{torch.dtype}, optional) the desired data type of        returned tensor. If specified, the input tensor is casted to        'dtype' while performing the operation. Default: None.}
}
\description{
Norm
}
\section{TEST }{


Returns the matrix norm or vector norm of a given tensor.
}

\examples{
if (torch_is_installed()) {

a = torch_arange(0, 9, dtype = torch_float())
b = a$reshape(list(3, 3))
torch_norm(a)
torch_norm(b)
torch_norm(a, Inf)
torch_norm(b, Inf)

}
}
