% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R
\name{torch_cholesky_solve}
\alias{torch_cholesky_solve}
\title{Cholesky_solve}
\arguments{
\item{input}{(Tensor) input matrix \eqn{b} of size \eqn{(*, m, k)},                where \eqn{*} is zero or more batch dimensions}

\item{input2}{(Tensor) input matrix \eqn{u} of size \eqn{(*, m, m)},                where \eqn{*} is zero of more batch dimensions composed of                upper or lower triangular Cholesky factor}

\item{upper}{(bool, optional) whether to consider the Cholesky factor as a                            lower or upper triangular matrix. Default: \code{False}.}

\item{out}{(Tensor, optional) the output tensor for \code{c}}
}
\description{
Cholesky_solve
}
\section{cholesky_solve(input, input2, upper=False, out=None) -> Tensor }{


Solves a linear system of equations with a positive semidefinite
matrix to be inverted given its Cholesky factor matrix \eqn{u}.

If \code{upper} is \code{False}, \eqn{u} is and lower triangular and \code{c} is
returned such that:

\deqn{
    c = (u u^T)^{{-1}} b
}
If \code{upper} is \code{True} or not provided, \eqn{u} is upper triangular
and \code{c} is returned such that:

\deqn{
    c = (u^T u)^{{-1}} b
}
\code{torch_cholesky_solve(b, u)} can take in 2D inputs \verb{b, u} or inputs that are
batches of 2D matrices. If the inputs are batches, then returns
batched outputs \code{c}
}

\examples{
if (torch_is_installed()) {

a = torch_randn(c(3, 3))
a = torch_mm(a, a$t()) # make symmetric positive definite
u = torch_cholesky(a)
a
b = torch_randn(c(3, 2))
b
torch_cholesky_solve(b, u)
torch_mm(a$inverse(), b)
}
}
