% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.r
\name{rescale_var}
\alias{rescale_var}
\title{Rescale a numeric variable}
\usage{
rescale_var(x, new_min = 0, new_max = 1, x_min = min(x), x_max = max(x))
}
\arguments{
\item{x}{a numeric vector}

\item{new_min}{The minimum value of the output}

\item{new_max}{The maximum value of the output}

\item{x_min}{The lowest possible value in x. By default this is the actual lowest value in x.}

\item{x_max}{The highest possible value in x. By default this is the actual highest value in x.}
}
\value{
a numeric vector
}
\description{
Rescale a numeric variable
}
\examples{
rescale_var(1:10)
rescale_var(1:10, new_min = -1, new_max = 1)
}
