% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.tna_permutation}
\alias{plot.tna_permutation}
\title{Plot the Significant Differences from a Permutation Test}
\usage{
\method{plot}{tna_permutation}(x, colors, ...)
}
\arguments{
\item{x}{A \code{tna_permutation} object.}

\item{colors}{See \code{\link[qgraph:qgraph]{qgraph::qgraph()}}.}

\item{...}{Arguments passed to \code{\link[=plot_model]{plot_model()}}.}
}
\value{
A \code{qgraph} object containing only the significant edges according
to the permutation test.
}
\description{
Plot the Significant Differences from a Permutation Test
}
\examples{
model_x <- tna(group_regulation[1:200, ])
model_y <- tna(group_regulation[1001:1200, ])
# Small number of iterations for CRAN
perm <- permutation_test(model_x, model_y, iter = 20)
plot(perm)

}
