% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/window.R
\name{new_window}
\alias{new_window}
\title{Create a new tmux window}
\usage{
new_window(
  target = NULL,
  name = NULL,
  focus = TRUE,
  start_directory = NULL,
  shell_command = NULL
)
}
\arguments{
\item{target}{A tmuxr_session or tmuxr_window. If \code{NULL}, the last session
is used.}

\item{name}{A string. Name of the window. If \code{NULL}, the
name determined by the shell command. Default: \code{NULL}.}

\item{focus}{A logical. If \code{FALSE}, the session does not make the new window
the current window. Default: \code{TRUE}.}

\item{start_directory}{A string. Working directory this window is run in.}

\item{shell_command}{A string. Shell command to be invoked when creating the
window. If \code{NULL}, the default shell is used.}
}
\value{
A tmuxr_window.
}
\description{
Create a new tmux window with name \code{name}.
When the shell command completes, the window closes.
}
\examples{
s <- new_session()
new_window()
kill_session(s)

}
