% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmF.R
\name{summary.tm}
\alias{summary.tm}
\title{Summarizing Trimmed Means Linear Model fits:}
\usage{
\method{summary}{tm}(object, ...)
}
\arguments{
\item{object}{an object of class "\code{tm}"}

\item{...}{user specified arguments}
}
\value{
\code{summary.tm} returns an list of summary statistics of the fitted trimmed means linear
model in \code{object}, with components
\item{call}{the matched call}
\item{n}{the number of observations per treatment group}
\item{dropout}{the proportion of dropout per treatment group}
\item{trimfrac}{the proportion of data that was trimmed away per treatment group}
\item{trimside}{specifies if lower or higher value trimming was performed}
\item{n_after_trimming}{the number of observations per treatment group after trimming}
\item{coefficients}{an array of coefficients with corresponding p-values and 95\% confidence intervals}
\item{Analysis_details}{reiterates trimming fraction and side, and, for \code{adjest=TRUE} specifies if the adjustment was performed on the comparator or treatment group.}
\item{SD_outcome}{an array of the standard deviation per treatment group, for the observed outcomes and for the trimmed outcomes}
}
\description{
\code{summary} method for class "\code{tm}".
}
\examples{
set.seed(123456)
test_dat <- as.data.frame(cbind(c(rep(0,500),rep(1,500)),
                          c(sort(rnorm(500,0,1)),sort(rnorm(500,1,1.5))),
                          rbinom(1000,2,0.4), rnorm(1000,0,1)))
colnames(test_dat) <- c("TR", "Y", "U", "U2")
test_dat$Y[1:200] <- NA
tm_obj <- tm(formula= Y ~ TR + U + U2, GR = "TR", trF = 0.5,
             side = "LOW", n_perm = 1000, adj_est = TRUE, data = test_dat)
summary(tm_obj)
coef(tm_obj)
}
\seealso{
\code{\link{tm}}. The function \code{\link{coef}}
extracts the array of regression coefficients with corresponding p-values and 95\% confidence intervals.
}
