% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmbstan.R
\name{tmbstan}
\alias{tmbstan}
\title{Draw MCMC samples from a TMB model object using Stan}
\usage{
tmbstan(
  obj,
  ...,
  lower = numeric(0),
  upper = numeric(0),
  laplace = FALSE,
  silent = TRUE,
  debug = FALSE
)
}
\arguments{
\item{obj}{TMB model object.}

\item{...}{Passed to \code{rstan::sampling} with some modifications - see details.}

\item{lower}{Vector of lower parameter bounds.}

\item{upper}{Vector of upper parameter bounds.}

\item{laplace}{Apply the Laplace approximation to \code{random} subset of parameters ? The default disables the Laplace approximation.}

\item{silent}{Be silent during samling ?}

\item{debug}{Should not be used.}
}
\value{
Object of class \code{stanfit}
}
\description{
Draw MCMC samples from a TMB model object using Stan
}
\details{
\code{tmbstan} works for models with or without random effects.

By default a full Bayesian analysis is carried out, i.e. both
parameters and random effects are sampled using MCMC. Models with
random effects will thus have the Laplace approximation disabled. It
is possible to mix the Laplace approximation with MCMC by setting
\code{laplace=TRUE}.
All methods provided by the \code{rstan} package can be applied to a
fitted object. Get a complete list using
\code{methods(class="stanfit")}.

Lower and upper bounds can be set using \code{lower} and \code{upper}.
The bounds can be specified in one of two ways. Either in short
format, i.e. have the same length as \code{obj$par}. Remaining
parameters (the random effects) are set as unbounded in this case.
Otherwise the bounds must be in long format, i.e. have the same
length as the full parameter vector \code{obj$env$par} including the
random effects.
In both cases \code{-Inf} and \code{Inf} are valid components of
\code{lower} and \code{upper} respectively.
Note that initial values must be within the specified bounds.

The function arguments \code{...} are passed to \code{rstan}'s
fitting function, see \code{?rstan::sampling}.
A few notable arguments are:
\itemize{
\item \code{chains} The number of chains.
\item \code{iter}   The number of iterations.
\item \code{init}   Initial values for the sampler.
Behaves like \code{rstan} with some additions:
\itemize{
\item Default is \code{"random"} - see \code{?stan}.
\item Special values \code{0} and \code{"0"} are allowed - see \code{?stan}.
\item Additional special characters \code{"par"} and \code{"last.par.best"} are allowed
      and will be looked up in the TMB model object.
      The value \code{"par"} signifies to start from the defaults of the model object.
      If an optimization has been carried out, the intial value \code{"last.par.best"}
      will start from the MLE.
\item We also allow to pass a single numeric vector, or a list of numeric vectors.
      List length must match the number of chains. Vector lengths must match the
      number of sampled parameters. Names are currently ignored.
\item Parameters
that do not follow the previous scheme (e.g. characters) are passed on
to \code{rstan} unchanged. If in doubt, use \code{rstan::get_inits} to inspect the
applied initial values.
}
\item \code{seed} Random seed.
}
}
\examples{
TMB::runExample("simple")
fit <- tmbstan(obj, chains=1)
class(fit)  ## "stanfit"

## The available methods are
methods(class="stanfit")

\dontrun{
## Pairs plot
pairs(fit, pars=names(obj$par))
}

## Trace plot
traceplot(fit, pars=names(obj$par), inc_warmup=TRUE)
}
