% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bb.R
\name{bb}
\alias{bb}
\title{Bounding box generator}
\usage{
bb(
  x = NA,
  ext = NULL,
  cx = NULL,
  cy = NULL,
  width = NULL,
  height = NULL,
  xlim = NULL,
  ylim = NULL,
  relative = FALSE,
  current.projection = NULL,
  projection = NULL,
  output = c("bbox", "matrix", "extent")
)
}
\arguments{
\item{x}{One of the following:
\itemize{
\item A shape (from class \code{\link[sp:Spatial]{Spatial}}, \code{\link[raster:Raster-class]{Raster}}, or \code{\link[sf:sf]{sf}} (simple features)).
\item A bounding box (either 2 by 2 matrix or an \code{\link[raster:Extent]{Extent}} object).
\item Open Street Map search query. The bounding is automatically generated by querying \code{x} from Open Street Map Nominatim. See \code{\link{geocode_OSM}} and \url{http://wiki.openstreetmap.org/wiki/Nominatim}.}
If \code{x} is not specified, a bounding box can be created from scratch (see details).}

\item{ext}{Extension factor of the bounding box. If 1, the bounding box is unchanged. Values smaller than 1 reduces the bounding box, and values larger than 1 enlarges the bounding box. This argument is a shortcut for both \code{width} and \code{height} with \code{relative=TRUE}. If a negative value is specified, then the shortest side of the bounding box (so width or height) is extended with \code{ext}, and the longest side is extended with the same absolute value. This is especially useful for bounding boxes with very low or high aspect ratios.}

\item{cx}{center x coordinate}

\item{cy}{center y coordinate}

\item{width}{width of the bounding box. These are either absolute or relative (depending on the argument \code{relative}).}

\item{height}{height of the bounding box. These are either absolute or relative (depending on the argument \code{relative}).}

\item{xlim}{limits of the x-axis. These are either absolute or relative (depending on the argument \code{relative}).}

\item{ylim}{limits of the y-axis. See \code{xlim}.}

\item{relative}{boolean that determines whether relative values are used for \code{width}, \code{height}, \code{xlim} and \code{ylim} or absolute. If \code{x} is unspecified, \code{relative} is set to \code{"FALSE"}.}

\item{current.projection}{projection that corresponds to the bounding box specified by \code{x}.}

\item{projection}{projection to transform the bounding box to.}

\item{output}{output format of the bounding box, one of:
\itemize{
\item \code{"bbox"} a \code{sf::bbox} object, which is a numeric vector of 4: xmin, ymin, xmax, ymax. This representation used by the \code{\link[sf:sf]{sf}} package.
\item \code{"matrix"} a 2 by 2 numeric matrix, where the rows correspond to x and y, and the columns to min and max. This representation used by the \code{sp} package.
\item \code{"extent"} an \code{raster::extent} object, which is a numeric vector of 4: xmin, xmax, ymin, ymax. This representation used by the \code{raster} package.
}}
}
\value{
bounding box (see argument \code{output})
}
\description{
Swiss army knife for bounding boxes. Modify an existing bounding box or create a new bounding box from scratch. See details.
}
\details{
An existing bounding box (defined by \code{x}) can be modified as follows:
\itemize{
\item Using the extension factor \code{ext}.
\item Changing the width and height with \code{width} and \code{height}. The argument \code{relavitve} determines whether relative or absolute values are used.
\item Setting the x and y limits. The argument \code{relavitve} determines whether relative or absolute values are used.}

A new bounding box can be created from scratch as follows:
\itemize{
\item Using the extension factor \code{ext}.
\item Setting the center coorinates \code{cx} and \code{cy}, together with the \code{width} and \code{height}.
\item Setting the x and y limits \code{xlim} and \code{ylim}
}
}
\examples{
if (require(tmap) && packageVersion("tmap") >= "2.0") {

    ## load shapes
    data(NLD_muni)
    data(World)

    ## get bounding box (similar to sp's function bbox)
    bb(NLD_muni)

    ## extent it by factor 1.10
    bb(NLD_muni, ext=1.10)

    ## convert to longlat
    bb(NLD_muni, projection=4326)

    ## change existing bounding box
    bb(NLD_muni, ext=1.5)
    bb(NLD_muni, width=2, relative = TRUE)
    bb(NLD_muni, xlim=c(.25, .75), ylim=c(.25, .75), relative = TRUE)

}

\dontrun{
if (require(tmap)) {
    bb("Limburg", projection = "rd")
    bb_italy <- bb("Italy", projection = "eck4")

    tm_shape(World, bbox=bb_italy) + tm_polygons()
    # shorter alternative: tm_shape(World, bbox="Italy") + tm_polygons()
}}
}
\seealso{
\code{\link{geocode_OSM}}
}
