% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palette_explorer.R
\docType{data}
\name{palette_explorer}
\alias{palette_explorer}
\alias{tmap.pal.info}
\title{Explore color palettes}
\format{An object of class \code{data.frame} with 40 rows and 4 columns.}
\usage{
palette_explorer()

tmap.pal.info
}
\description{
\code{palette_explorer()} starts an interactive tool shows all Color Brewer and viridis palettes, where the number of colors can be adjusted as well as the constrast range. Categorical (qualitative) palettes can be stretched when the number of colors exceeds the number of palette colors. Output code needed to get the desired color values is generated. Finally, all colors can be tested for color blindness. The data.frame \code{tmap.pal.info} is similar to \code{\link[RColorBrewer:brewer.pal.info]{brewer.pal.info}}, but extended with the color palettes from viridis.
}
\examples{
\dontrun{
if (require(shiny) && require(shinyjs)) {
    palette_explorer()
}
}
}
\references{
\url{http://www.color-blindness.com/types-of-color-blindness/}
}
\seealso{
\code{\link{get_brewer_pal}}, \code{\link[dichromat:dichromat]{dichromat}}, \code{\link[RColorBrewer:RColorBrewer]{RColorBrewer}}
}
\keyword{datasets}
