% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_layers.R
\name{tm_sf}
\alias{tm_sf}
\title{Draw simple features}
\usage{
tm_sf(
  col = NA,
  size = 0.02,
  shape = 16,
  lwd = 1,
  lty = "solid",
  alpha = NA,
  palette = NULL,
  border.col = NA,
  border.lwd = 1,
  border.lty = "solid",
  border.alpha = NA,
  group = NA,
  ...
)
}
\arguments{
\item{col}{color of the simple features. See the \code{col} argument of \code{\link{tm_polygons}}, \code{\link{tm_lines}} and \code{\link{tm_symbols}}.}

\item{size}{size of the dots. See the \code{size} argument \code{\link{tm_symbols}}. By default, the size is similar to dot size (see \code{\link{tm_dots}})}

\item{shape}{shape of the dots. See the \code{shape} argument \code{\link{tm_symbols}}. By default, dots are shown.}

\item{lwd}{width of the lines. See the \code{lwd} argument of \code{\link{tm_lines}}}

\item{lty}{type of the lines. See the \code{lty} argument of \code{\link{tm_lines}}}

\item{alpha}{transparency number. See \code{alpha} argument of \code{\link{tm_polygons}}, \code{\link{tm_lines}} and \code{\link{tm_symbols}}}

\item{palette}{palette. See \code{palette} argument of \code{\link{tm_polygons}}, \code{\link{tm_lines}} and \code{\link{tm_symbols}}}

\item{border.col}{color of the borders. See \code{border.col} argument of \code{\link{tm_polygons}} and \code{\link{tm_symbols}}.}

\item{border.lwd}{line width of the borders. See \code{border.lwd} argument of \code{\link{tm_polygons}} and \code{\link{tm_symbols}}.}

\item{border.lty}{line type of the borders. See \code{border.lwd} argument of \code{\link{tm_polygons}} and \code{\link{tm_symbols}}.}

\item{border.alpha}{transparency of the borders. See \code{border.alpha} argument of \code{\link{tm_polygons}} and \code{\link{tm_symbols}}.}

\item{group}{name of the group to which this layer belongs in view mode. Each group can be selected or deselected in the layer control item. Set \code{group = NULL} to hide the layer in the layer control item. By default, it will be set to the name of the shape (specified in \code{\link{tm_shape}}).}

\item{...}{other arguments passed on to \code{\link{tm_polygons}}, \code{\link{tm_lines}} and \code{\link{tm_symbols}}}
}
\value{
\code{\link{tmap-element}}
}
\description{
Creates a \code{\link{tmap-element}} that draws simple features. Basically, it is a stack of \code{\link{tm_polygons}}, \code{\link{tm_lines}} and \code{\link{tm_dots}}. In other words, polygons are plotted as polygons, lines as lines and points as dots.
}
\examples{
data(World)

World$geometry[World$continent == "Africa"] <- 
  sf::st_centroid(World$geometry[World$continent == "Africa"])
World$geometry[World$continent == "South America"] <- 
  sf::st_cast(World$geometry[World$continent == "South America"], 
    "MULTILINESTRING", group_or_split = FALSE)

tm_shape(World) + 
	tm_sf()
}
\seealso{
\href{../doc/tmap-getstarted.html}{\code{vignette("tmap-getstarted")}}
}
\concept{simple features}
