% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_method_07_kRp.corpus-class_correct.R
\docType{methods}
\name{correct.hyph,kRp.corpus-method}
\alias{correct.hyph,kRp.corpus-method}
\alias{correct.hyph}
\title{Methods to correct kRp.corpus objects}
\usage{
\S4method{correct.hyph}{kRp.corpus}(obj, word = NULL, hyphen = NULL, cache = TRUE)
}
\arguments{
\item{obj}{An object of class \code{\link[tm.plugin.koRpus:kRp.corpus-class]{kRp.corpus}}.}

\item{word}{A character string,
      the (possibly incorrectly hyphenated) \code{word} entry to be replaced with \code{hyphen}.}

\item{hyphen}{A character string,
      the new manually hyphenated version of \code{word}. Mustn't contain
anything other than characters of \code{word} plus the hyphenation mark \code{"-"}.}

\item{cache}{Logical, if \code{TRUE},
      the given hyphenation will be added to the sessions' hyphenation cache.
Existing entries for the same word will be replaced.}
}
\value{
An object of the same class as \code{obj}.
}
\description{
These methods enable you to correct errors that occurred during automatic processing,
e.g., wrong hyphenation.
}
\details{
For details on what these methods do on a per text object basis, please refer to the
documentation of \code{\link[sylly:correct.hyph]{correct.hyph}} in the \code{sylly}
package.
}
