% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tipitaka-docs.R
\docType{data}
\name{sutta_pitaka}
\alias{sutta_pitaka}
\title{All the books of the Sutta Pitaka}
\format{
A tibble with the variables:
\describe{
  \item{book}{Abbreviated title}
  \item{name}{Full title}
}
}
\usage{
sutta_pitaka
}
\description{
A subset of tipitaka_names consisting of only the books of
the Sutta Pitaka. These are easier to read if you call
\code{stringi::stri_unescape_unicode} first.
}
\examples{
# Clean up the Unicode characters to make things more readble:
sutta_pitaka$name <-
  stringi::stri_unescape_unicode(sutta_pitaka$name)
# Count all the words in the Suttas:
sum(
  unique(
    tipitaka_long[tipitaka_long$book \%in\% sutta_pitaka$book, "total"]))

# Count another way:
sum(tipitaka_long[tipitaka_long$book \%in\% sutta_pitaka$book, "n"])

# Create a tibble of just the Suttas
sutta_wide <-
  tipitaka_wide[row.names(tipitaka_wide) \%in\% sutta_pitaka$book,]

}
\keyword{datasets}
