% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tdiff.R, R/print_summ_str.R
\name{tdiff}
\alias{tdiff}
\alias{is.tdiff}
\alias{as.tdiff}
\alias{as.tdiff.numeric}
\alias{as.tdiff.character}
\alias{as.tdiff.difftime}
\alias{years}
\alias{qrtrs}
\alias{mnths}
\alias{weeks}
\alias{days}
\alias{hours}
\alias{mins}
\alias{secs}
\alias{as.character.tdiff}
\alias{format.tdiff}
\alias{as.data.frame.tdiff}
\alias{[.tdiff}
\alias{[<-.tdiff}
\alias{[[.tdiff}
\alias{[[<-.tdiff}
\alias{rep.tdiff}
\alias{c.tdiff}
\alias{Math.tdiff}
\alias{Summary.tdiff}
\alias{mean.tdiff}
\alias{unique.tdiff}
\alias{print.tdiff}
\alias{summary.tdiff}
\title{Time Differences}
\usage{
is.tdiff(x)

as.tdiff(x, ...)

\method{as.tdiff}{numeric}(x, unit, ...)

\method{as.tdiff}{character}(x, ...)

\method{as.tdiff}{difftime}(x, ...)

years(x)

qrtrs(x)

mnths(x)

weeks(x)

days(x)

hours(x)

mins(x)

secs(x)

\method{as.character}{tdiff}(x, ...)

\method{format}{tdiff}(x, ...)

\method{as.data.frame}{tdiff}(x, ...)

\method{[}{tdiff}(x, i)

\method{[}{tdiff}(x, i) <- value

\method{[[}{tdiff}(x, i)

\method{[[}{tdiff}(x, i) <- value

\method{rep}{tdiff}(x, ...)

\method{c}{tdiff}(...)

\method{Math}{tdiff}(x, ...)

\method{Summary}{tdiff}(..., na.rm = FALSE)

\method{mean}{tdiff}(x, na.rm = FALSE, ...)

\method{unique}{tdiff}(x, ...)

\method{print}{tdiff}(x, ...)

\method{summary}{tdiff}(object, ...)
}
\arguments{
\item{x}{a numeric vector or any R object coercible to \code{tdiff},
for \code{as.tdiff} and \code{years}, \code{qrtrs}, etc.;
an object of \code{tdiff} class for methods.}

\item{...}{further arguments passed to or from other methods.}

\item{unit}{a character string, name of the time unit, see Details.}

\item{i}{an integer vector of indices or a logical vector indicating selection.}

\item{value}{replacement value.}

\item{na.rm}{a logical value indicating whether missing values should be removed.}

\item{object}{an object of \code{tdiff} class.}
}
\value{
\code{as.tdiff} as well as convenience functions \code{years},
\code{qrtrs}, etc., return objects of \code{tdiff} class.

\code{is.tdiff} returns a logical value.

In general, methods for \code{tdiff} return objects of \code{tdiff} class.

\code{as.character} and \code{format} return character vectors.

\code{as.data.frame} returns a data frame with a single
column and the number of rows equal to the length of the argument.

\code{print} returns its argument invisibly and is used for its side effect.

\code{summary} returns an object of class \code{c("summaryDefault", "table")}.
}
\description{
Objects of \code{tdiff} class represent time differences and are similar
to \code{\link[base]{difftime}} objects. \code{tdiff} objects are created
by subtracting two time indices (of types other than \code{"i"} and \code{"n"})
or via calls to \code{as.tdiff} method. An alternative way of constructing
\code{tdiff} objects is to call \code{years}, \code{qrtrs}, \code{mnths},
\code{weeks}, \code{days}, \code{hours}, \code{mins}, and \code{secs}
convenience functions.

The following units (argument \code{unit}) are supported:
\describe{
    \item{\code{"y"} (\code{"year"}, \code{"years"})}{differences in years,}
    \item{\code{"q"} (\code{"quarter"}, \code{"quarters"})}{differences in quarters,}
    \item{\code{"m"} (\code{"month"}, \code{"months"})}{differences in months,}
    \item{\code{"w"} (\code{"week"}, \code{"weeks"})}{differences in weeks,}
    \item{\code{"d"} (\code{"day"}, \code{"days"})}{differences in days,}
    \item{\code{"h"} (\code{"hour"}, \code{"hours"})}{differences in hours,}
    \item{\code{"min"} (\code{"mins"}, \code{"minute"}, \code{"minutes"})}{differences in minutes,}
    \item{\code{"s"} (\code{"secs"}, \code{"second"}, \code{"seconds"})}{differences in seconds.}
}

Standard methods for vectors and conversion from / to numeric and character
vectors are implemented for this class.
}
\details{
\code{tdiff} objects are implemented as vectors of integers (for differences
in years, quarters, months, weeks, and days) or vectors of doubles (for time
differences). Time differences are internally represented in seconds
but when printing the actual time unit (hour, minute, second) is automatically
inferred and used.

Valid ranges for \code{tdiff} values depend on unit. These are defined
by differences of the maximal and minimal valid time indices of the type
corresponding to the time unit.
}
\note{
Since \code{as.difftime} is not implemented in \pkg{base} as an S3 generic,
conversion from \code{tdiff} to \code{difftime} is not provided.
}
\examples{
# how many days have passed since Jan 1, 2000?
today() - as.date("2000-01-01")
# how many months have passed since Sep 2008?
as.month(today()) - as.month("2008-09")
# create time differences in quarters
as.tdiff(-2:2, "q")
# same
(x <- qrtrs(-2:2))
# add to today
today() + x

}
\seealso{
\link{Ops} for operations on time indices and
time differences.
}
