% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recipes-step_fourier.R
\name{step_fourier}
\alias{step_fourier}
\alias{tidy.step_fourier}
\title{Fourier Features for Modeling Seasonality}
\usage{
step_fourier(
  recipe,
  ...,
  period,
  K,
  role = "predictor",
  trained = FALSE,
  columns = NULL,
  scale_factor = NULL,
  skip = FALSE,
  id = rand_id("fourier")
)

\method{tidy}{step_fourier}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{A single column with class \code{Date} or
\code{POSIXct}. See \code{\link[recipes:selections]{recipes::selections()}} for more details.
For the \code{tidy} method, these are not currently used.}

\item{period}{The numeric period for the oscillation frequency.
See details for examples of \code{period} specification.}

\item{K}{The number of orders to include for each sine/cosine
fourier series. More orders increase the number of fourier terms and
therefore the variance of the fitted
model at the expense of bias. See details for examples of \code{K} specification.}

\item{role}{For model terms created by this step, what analysis
role should they be assigned?. By default, the function assumes
that the new variable columns created by the original variables
will be used as predictors in a model.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{columns}{A character string of variables that will be
used as inputs. This field is a placeholder and will be
populated once \code{recipes::prep()} is used.}

\item{scale_factor}{A factor for scaling the numeric index extracted
from the date or date-time feature. This is a placeholder and will be populated
once \code{recipes::prep()} is used.}

\item{skip}{A logical. Should the step be skipped when the recipe is
baked by bake.recipe()? While all operations are baked when prep.recipe()
is run, some operations may not be able to be conducted on new data
(e.g. processing the outcome variable(s)). Care should be taken when
using skip = TRUE as it may affect the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{step_fourier} object.}
}
\value{
For \code{step_fourier}, an updated version of recipe with
the new step added to the sequence of existing steps (if any).
For the \code{tidy} method, a tibble with columns \code{terms}
(the selectors or variables selected), \code{value} (the feature
names).
}
\description{
\code{step_fourier} creates a a \emph{specification} of a recipe
step that will convert a Date or Date-time column into a Fourier
series
}
\details{
\strong{Date Variable}

Unlike other steps, \code{step_fourier} does \emph{not}
remove the original date variables. \code{\link[recipes:step_rm]{recipes::step_rm()}} can be
used for this purpose.

\strong{Period Specification}

The \code{period} argument is used to generate the distance between peaks
in the fourier sequence. The key is to line up the peaks with unique
seasonalities in the data.

For Daily Data, typical period specifications are:
\itemize{
\item Yearly frequency is 365
\item Quarterly frequency is 365 / 4 = 91.25
\item Monthly frequency is 365 / 12 = 30.42
}

\strong{K Specification}

The \code{K} argument specifies the maximum number of orders of Fourier terms.
Examples:
\itemize{
\item Specifying \code{period = 365} and \code{K = 1} will return a \code{cos365_K1} and \code{sin365_K1} fourier series
\item Specifying \code{period = 365} and \code{K = 2} will return a \code{cos365_K1}, \code{cos365_K2}, \code{sin365_K1} and \code{sin365_K2}
sequence, which tends to increase the models ability to fit vs the \code{K = 1} specification
(at the expense of possibly overfitting).
}

\strong{Multiple values of \code{period} and \code{K}}

It's possible to specify multiple values of \code{period} in a single
step such as \verb{step_fourier(period = c(91.25, 365), K = 2}.
This returns 8 Fouriers series:
\itemize{
\item \code{cos91.25_K1}, \code{sin91.25_K1}, \code{cos91.25_K2}, \code{sin91.25_K2}
\item \code{cos365_K1}, \code{sin365_K1}, \code{cos365_K2}, \code{sin365_K2}
}
}
\examples{
library(recipes)
library(tidyverse)
library(tidyquant)
library(timetk)

FB_tbl <- FANG \%>\%
    filter(symbol == "FB") \%>\%
    select(symbol, date, adjusted)

# Create a recipe object with a timeseries signature step
# - 252 Trade days per year
# - period = c(252/4, 252): Adds quarterly and yearly fourier series
# - K = 2: Adds 1st and 2nd fourier orders

rec_obj <- recipe(adjusted ~ ., data = FB_tbl) \%>\%
    step_fourier(date, period = c(252/4, 252), K = 2)

# View the recipe object
rec_obj

# Prepare the recipe object
prep(rec_obj)

# Bake the recipe object - Adds the Fourier Series
bake(prep(rec_obj), FB_tbl)

# Tidy shows which features have been added during the 1st step
#  in this case, step 1 is the step_timeseries_signature step
tidy(prep(rec_obj))
tidy(prep(rec_obj), number = 1)

}
\seealso{
Time Series Analysis:
\itemize{
\item Engineered Features: \code{\link[=step_timeseries_signature]{step_timeseries_signature()}}, \code{\link[=step_holiday_signature]{step_holiday_signature()}}, \code{\link[=step_fourier]{step_fourier()}}
\item Diffs & Lags \code{\link[=step_diff]{step_diff()}}, \code{recipes::step_lag()}
\item Smoothing: \code{\link[=step_slidify]{step_slidify()}}, \code{\link[=step_smooth]{step_smooth()}}
\item Variance Reduction: \code{\link[=step_box_cox]{step_box_cox()}}
\item Imputation: \code{\link[=step_ts_impute]{step_ts_impute()}}, \code{\link[=step_ts_clean]{step_ts_clean()}}
\item Padding: \code{\link[=step_ts_pad]{step_ts_pad()}}
}

Main Recipe Functions:
\itemize{
\item \code{recipes::recipe()}
\item \code{recipes::prep()}
\item \code{recipes::bake()}
}
}
\concept{dates}
\concept{model_specification}
\concept{preprocessing}
\concept{variable_encodings}
\keyword{datagen}
