% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createConObj.R
\name{createConObj}
\alias{createConObj}
\title{Conveniently Create Connection Object to PostgreSQL based timeseriesdb}
\usage{
createConObj(dbuser = Sys.info()["user"],
  dbname = Sys.getenv("TIMESERIESDB_NAME"),
  dbhost = Sys.getenv("TIMESERIESDB_HOST"), passwd, dbport = 5432)
}
\arguments{
\item{dbuser}{character username. Defaults to reading username from Sys.info()}

\item{dbname}{character name of the database, assumes dbname is stored in TIMESERIESDB_NAME.}

\item{dbhost}{character host address, asssumes dbhost ist stored in TIMESERIESDB_HOST.}

\item{passwd}{character password is used. No defaults, best way to pass a password is to 
.rs.askForPassword to hide password entries when using R Studio.}

\item{dbport}{integer port number defaults to 5432 for postgres}
}
\description{
Create a conection object while getting user information from the R session. 
Also standard db parameters like port and driver are set. Yet flexible information like 
host or dbname should be added to Sys.setenv environments.
}
