% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim-pc-hazard.r
\name{rcrisk}
\alias{rcrisk}
\alias{cause.pchazard.sim}
\title{Simulation of Piecewise constant hazard models with two causes (Cox).}
\usage{
rcrisk(cumhaz1, cumhaz2, rr1, rr2, n = NULL, cens = NULL, rrc = NULL, ...)
}
\arguments{
\item{cumhaz1}{cumulative hazard of cause 1}

\item{cumhaz2}{cumulative hazard of cause 1}

\item{rr1}{number of simulations or vector of relative risk for simuations.}

\item{rr2}{number of simulations or vector of relative risk for simuations.}

\item{n}{number of simulation if rr not given}

\item{cens}{to censor further , rate or cumumlative hazard}

\item{rrc}{retlativ risk for censoring.}

\item{...}{arguments for rchaz}
}
\description{
Simulates data from piecwise constant baseline hazard that can also be of
Cox type. Censor data at highest value of the break points for either of the
cumulatives.
}
\examples{
data(TRACE)

cox1 <- cox.aalen(Surv(time,status==9)~prop(vf)+prop(chf)+prop(wmi),
            data=TRACE,robust=0)
cox2 <-  cox.aalen(Surv(time,status==0)~prop(vf)+prop(chf)+prop(wmi),
            data=TRACE,robust=0)

X1 <- TRACE[,c("vf","chf","wmi")]
n <- 1000
xid <- sample(1:nrow(X1),n,replace=TRUE)
Z1 <- X1[xid,]
Z2 <- X1[xid,]
rr1 <- exp(as.matrix(Z1) \%*\% cox1$gamma)
rr2 <- exp(as.matrix(Z2) \%*\% cox2$gamma)

cumhaz1 <- cox1$cum
cumhaz2 <- cox2$cum
d <-  rcrisk(cox1$cum,cox2$cum,rr1,rr2)
dd <- cbind(d,Z1)
sc1 <-   cox.aalen(Surv(time,status==1)~prop(vf)+prop(chf)+prop(wmi),
                  data=dd,robust=0)
cbind(sc1$gamma, cox1$gamma)
sc2 <-  cox.aalen(Surv(time,status==2)~prop(vf)+prop(chf)+prop(wmi),
                  data=dd,robust=0)
cbind(sc2$gamma, cox2$gamma)
par(mfrow=c(1,2))
plot(cox1); lines(sc1$cum,col=2)
plot(cox2$cum,type="l");
lines(sc2$cum,col=2)

}
\author{
Thomas Scheike
}
\keyword{survival}
