% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unit_guess.R
\name{unit_guess}
\alias{unit_guess}
\title{Guess time unit and extract basic information.}
\usage{
unit_guess(x)
}
\arguments{
\item{x}{This can be 1 of 4 options:
\itemize{
\item A string, e.g. "7 days"
\item Lubridate duration or period object, e.g. \code{days(1)} or \code{ddays(1)}.
\item A list, e.g. list("days" = 7)
\item A number, e.g. 5
}}
}
\value{
A list of length 3, including the unit, number and scale.
}
\description{
This is a simple R function to convert time units to a
common unit, with number and scale. \cr
See \code{.time_units} for a list of accepted
time units.
}
\examples{
library(timeplyr)
\dontshow{
.n_dt_threads <- data.table::getDTthreads()
.n_collapse_threads <- collapse::get_collapse()$nthreads
data.table::setDTthreads(threads = 2L)
collapse::set_collapse(nthreads = 1L)
}
# Single units
unit_guess("days")
unit_guess("hours")

# Multi-units
unit_guess("7 days")
unit_guess("0.5 hours")

# Negative units
unit_guess("-7 days")
unit_guess("-.12 days")

# Exotic units
unit_guess("fortnights")
unit_guess("decades")
.extra_time_units

# list input is accepted
unit_guess(list("months" = 12))
# With a list, a vector of numbers is accepted
unit_guess(list("months" = 1:10))
unit_guess(list("days" = -10:10 \%\% 7))

# Numbers also accepted
unit_guess(100)
\dontshow{
data.table::setDTthreads(threads = .n_dt_threads)
collapse::set_collapse(nthreads = .n_collapse_threads)
}
}
