% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tk_index.R
\name{tk_index}
\alias{tk_index}
\alias{tk_index}
\alias{has_timekit_idx}
\title{Extract an index of date or datetime from time series objects, models, forecasts}
\usage{
tk_index(data, timekit_idx = FALSE, silent = FALSE)

has_timekit_idx(data)
}
\arguments{
\item{data}{A time-based tibble, time-series object, time-series model,
or \code{forecast} object.}

\item{timekit_idx}{If \code{timekit_idx} is \code{TRUE} a timekit time-based index attribute is attempted to be returned.
If \code{FALSE} the default index is returned. See discussion below for further details.}

\item{silent}{Used to toggle printing of messages and warnings.}
}
\value{
Returns a vector of date or date times
}
\description{
Extract an index of date or datetime from time series objects, models, forecasts
}
\details{
\code{tk_index()} is used to extract the date or datetime index from various
time series objects, models and forecasts.
The method can be used on \code{tbl}, \code{xts}, \code{zoo}, \code{zooreg}, and \code{ts} objects.
The method can additionally be used on \code{forecast} objects and a number of
objects generated by modeling functions such as \code{Arima}, \code{ets}, and \code{HoltWinters}
classes to get the index of the underlying data.

The boolean \code{timekit_idx} argument is applicable to regularized time series objects
such as \code{ts} and \code{zooreg} classes that have both a regularized index and \emph{potentially}
a "timekit index" (a time-based attribute).
When set to \code{FALSE} the regularized index is returned.
When set to \code{TRUE} the time-based timekit index is returned \emph{if present}.

\code{has_timekit_idx()} is used to determine if the object has a timekit index attribute
and can thus benefit from the \code{tk_index(timekit_idx = TRUE)}.
\code{TRUE} indicates the "timekit index" attribute is present.
\code{FALSE} indicates the "timekit index" attribute is not present.
If \code{FALSE}, the \code{tk_index()} function will return the default index for the data type.

\strong{Important Note}: To gain the benefit of \code{timekit_idx} the time series
must have a timekit index.
Use \code{has_timekit_idx} to determine if the object has a timekit index.
This is particularly important for \code{ts} objects, which
by default do not contain a time-based index and therefore must be coerced from time-based
objects such as \code{tbl}, \code{xts}, or \code{zoo} using the \code{tk_ts()} function in order
to get the "timekit index" attribute.
Refer to \code{\link[=tk_ts]{tk_ts()}} for creating persistent date / datetime index
during coercion to \code{ts}.
}
\examples{
library(tidyverse)
library(timekit)

# Create time-based tibble
data_tbl <- tibble::tibble(
    date = seq.Date(from = as.Date("2000-01-01"), by = 1, length.out = 5),
    x    = rnorm(5) * 10,
    y    = 5:1
)
tk_index(data_tbl) # Returns time-based index vector

# Coerce to ts using tk_ts(): Preserves time-basis
data_ts <- tk_ts(data_tbl)
tk_index(data_ts, timekit_idx = FALSE) # Returns regularized index
tk_index(data_ts, timekit_idx = TRUE)  # Returns original time-based index vector

# Coercing back to tbl
tk_tbl(data_ts, timekit_idx = FALSE) # Returns regularized tbl
tk_tbl(data_ts, timekit_idx = TRUE)  # Returns time-based tbl



}
\seealso{
\code{\link[=tk_ts]{tk_ts()}}, \code{\link[=tk_tbl]{tk_tbl()}}, \code{\link[=tk_xts]{tk_xts()}}, \code{\link[=tk_zoo]{tk_zoo()}}, \code{\link[=tk_zooreg]{tk_zooreg()}}
}
