% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Config.R
\name{tiledb_config}
\alias{tiledb_config}
\title{Creates a \code{tiledb_config} object}
\usage{
tiledb_config(config = NA_character_)
}
\arguments{
\item{config}{(optional) character vector of config parameter names, values}
}
\value{
\code{tiledb_config} object
}
\description{
Note that for actually setting persistent values, the (altered) config
object needs to used to create (or update) the \code{tiledb_ctx} object. Similarly,
to check whether values are set, one should use the \code{config} method
of the of the \code{tiledb_ctx} object. Examples for this are
\code{ctx <- tiledb_ctx(limitTileDBCores())} to use updated configuration values to
create a context object, and \code{cfg <- config(ctx)} to retrieve it.
}
\examples{
\dontshow{ctx <- tiledb_ctx(limitTileDBCores())}
cfg <- tiledb_config()
cfg["sm.tile_cache_size"]

# set tile cache size to custom value
cfg <- tiledb_config(c("sm.tile_cache_size" = "100"))
cfg["sm.tile_cache_size"]

}
