% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pumas.R
\name{pumas}
\alias{pumas}
\title{Download a Public Use Microdata Area (PUMA) shapefile into R}
\usage{
pumas(state, cb = FALSE, year = NULL, ...)
}
\arguments{
\item{state}{The two-digit FIPS code (string) of the state you want. Can also
be state name or state abbreviation.}

\item{cb}{If cb is set to TRUE, download a generalized (1:500k)
states file.  Defaults to FALSE (the most detailed TIGER/Line file)}

\item{year}{the data year (defaults to 2015).}

\item{...}{arguments to be passed to the underlying `load_tiger` function, which is not exported.
Options include \code{refresh}, which specifies whether or not to re-download shapefiles
(defaults to \code{FALSE}).}
}
\description{
Public use microdata areas (PUMAs) are decennial census areas that have been
defined for the tabulation and dissemination of Public Use Microdata Sample
(PUMS) data, American Community Survey (ACS) data, and ACS period estimates.
For the 2010 Census, the State Data Centers (SDCs) in each state, the
District of Columbia, and the Commonwealth of Puerto Rico were given the
opportunity to delineate PUMAs within their state or
statistically equivalent entity. All PUMAs must nest within states and have
a minimum population threshold of 100,000 persons. 2010 PUMAs were built on
census tracts and cover the entirety of the United States, Puerto Rico,
Guam, and the U.S. Virgin Islands. Because they do not meet the minimum
population requirement, the Commonwealth of the Northern Mariana Islands
and American Samoa do not contain any 2010 PUMAs.
}
\examples{
\dontrun{
library(tigris)
library(sp)

us_states <- unique(fips_codes$state)[1:51]

continental_states <- us_states[!us_states \%in\% c("AK", "HI")]
pumas_list <- lapply(continental_states, function(x) {
  pumas(state = x, cb = TRUE)
  })

us_pumas <- rbind_tigris(pumas_list)

plot(us_pumas)
}
}
\seealso{
\url{http://www.census.gov/geo/reference/puma.html}

Other general area functions: \code{\link{block_groups}},
  \code{\link{blocks}}, \code{\link{counties}},
  \code{\link{county_subdivisions}}, \code{\link{places}},
  \code{\link{school_districts}}, \code{\link{states}},
  \code{\link{tracts}}, \code{\link{zctas}}
}

