% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_write_item_to_cache.R
\name{tw_write_item_to_cache}
\alias{tw_write_item_to_cache}
\title{Writes item to cache}
\usage{
tw_write_item_to_cache(
  id,
  item_df,
  language = "all_available",
  overwrite_cache = FALSE
)
}
\arguments{
\item{id}{A characther vector, must start with Q, e.g. "Q180099" for the anthropologist Margaret Mead. Can also be a data frame of one row, typically generated with \code{tw_search()} or a combination of \code{tw_search()} and \code{tw_filter_first()}.}

\item{item_df}{A data frame with two columns typically generated with \code{tw_get(include_id = FALSE)}.}

\item{language}{Defaults to "all_available". By default, returns dataset with labels in all available languages. If given, only in the chosen language. For available values, see https://www.wikidata.org/wiki/Help:Wikimedia_language_codes/lists/all}

\item{overwrite_cache}{Logical, defaults to FALSE. If TRUE, it overwrites the table in the local sqlite database. Useful if the original Wikidata object has been updated.}
}
\value{
Nothing, used for its side effects.
}
\description{
Writes item to cache. Typically used internally, but exported to enable custom caching solutions.
}
\examples{

tw_set_cache_folder(path = fs::path(tempdir(), paste(sample(letters, 24), collapse = "")))
tw_create_cache_folder(ask = FALSE)
tw_disable_cache()

df_from_api <- tw_get(id = "Q180099", language = "en")

df_from_cache <- tw_get_cached_item(
  id = "Q180099",
  language = "en"
)

is.null(df_from_cache) # expect TRUE, as nothing has yet been stored in cache

tw_write_item_to_cache(
  id = "Q180099",
  item_df = df_from_api,
  language = "en"
)

df_from_cache <- tw_get_cached_item(
  id = "Q180099",
  language = "en"
)

is.null(df_from_cache) # expect a data frame, same as df_from_api
}
