% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solveresid_o3.R
\name{solveresid_o3_once}
\alias{solveresid_o3_once}
\title{Apply `solveresid_o3` to a data frame and create a new column with residual ozone dose}
\usage{
solveresid_o3_once(df, input_water = "defined_water", dose = 0, time = 0)
}
\arguments{
\item{df}{a data frame containing a water class column, which has already been computed using \code{\link{define_water_chain}}}

\item{input_water}{name of the column of Water class data to be used as the input for this function. Default is "defined_water".}

\item{dose}{Applied ozone dose in mg/L}

\item{time}{Ozone contact time in minutes}
}
\value{
A data frame containing the original data frame and columns for ozone dosed, time, and ozone residual.
}
\description{
This function allows \code{\link{solveresid_o3}} to be added to a piped data frame.
One additional column will be added to the data frame; the residual ozone dose (mg/L)
}
\details{
The data input comes from a `water` class column, initialized in \code{\link{define_water}} or \code{\link{balance_ions}}.

 For large datasets, using `fn_once` or `fn_chain` may take many minutes to run. These types of functions use the furrr package
 for the option to use parallel processing and speed things up. To initialize parallel processing, use
 `plan(multisession)` or `plan(multicore)` (depending on your operating system) prior to your piped code with the
 `fn_once` or `fn_chain` functions. Note, parallel processing is best used when your code block takes more than a minute to run,
 shorter run times will not benefit from parallel processing.
}
\examples{
library(dplyr)
ozone_resid <- water_df \%>\%
  mutate(br = 50) \%>\%
  define_water_chain() \%>\%
  solveresid_o3_once(dose = 2, time = 10)

ozone_resid <- water_df \%>\%
  mutate(br = 50) \%>\%
  define_water_chain() \%>\%
  mutate(
    dose = seq(1, 12, 1),
    time = seq(2, 24, 2)
  ) \%>\%
  solveresid_o3_once()

}
