% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/balance_ions.R
\name{balance_ions_chain}
\alias{balance_ions_chain}
\title{Apply `balance_ions` within a dataframe and output a column of `water` class to be chained to other tidywater functions}
\usage{
balance_ions_chain(
  df,
  input_water = "defined_water",
  output_water = "balanced_water"
)
}
\arguments{
\item{df}{a data frame containing a water class column, which has already been computed using \code{\link{define_water_chain}}}

\item{input_water}{name of the column of water class data to be used as the input for this function. Default is "defined_water".}

\item{output_water}{name of the output column storing updated parameters with the class, water. Default is "balanced_water".}
}
\value{
A data frame containing a water class column with updated ions to balance water charge.
}
\description{
This function allows \code{\link{balance_ions}} to be added to a piped data frame.
Its output is a `water` class, and can therefore be used with "downstream" tidywater functions.
}
\details{
For large datasets, using `fn_once` or `fn_chain` may take many minutes to run. These types of functions use the furrr package
 for the option to use parallel processing and speed things up. To initialize parallel processing, use
 `plan(multisession)` or `plan(multicore)` (depending on your operating system) prior to your piped code with the
 `fn_once` or `fn_chain` functions. Note, parallel processing is best used when your code block takes more than a minute to run,
 shorter run times will not benefit from parallel processing.
}
\examples{
library(purrr)
library(furrr)
library(tidyr)
library(dplyr)

example_df <- water_df \%>\%
  define_water_chain() \%>\%
  balance_ions_chain() \%>\%
  chemdose_ph_chain(naoh = 5)

example_df <- water_df \%>\%
  define_water_chain() \%>\%
  balance_ions_chain(output_water = "balanced ions, balanced life") \%>\%
  chemdose_ph_chain(input_water = "balanced ions, balanced life", naoh = 5)

# Initialize parallel processing
plan(multisession, workers = 2) # Remove the workers argument to use all available compute
example_df <- water_df \%>\%
  define_water_chain() \%>\%
  balance_ions_chain() \%>\%
  chemdose_ph_chain(naoh = 5)

# Optional: explicitly close multisession processing
plan(sequential)

}
\seealso{
\code{\link{balance_ions}}
}
