% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unnest_ngrams.R
\name{unnest_ngrams}
\alias{unnest_ngrams}
\alias{unnest_skip_ngrams}
\title{Wrapper around unnest_tokens for n-grams}
\usage{
unnest_ngrams(
  tbl,
  output,
  input,
  n = 3L,
  n_min = n,
  ngram_delim = " ",
  format = c("text", "man", "latex", "html", "xml"),
  to_lower = TRUE,
  drop = TRUE,
  collapse = NULL,
  ...
)

unnest_skip_ngrams(
  tbl,
  output,
  input,
  n_min = 1,
  n = 3,
  k = 1,
  format = c("text", "man", "latex", "html", "xml"),
  to_lower = TRUE,
  drop = TRUE,
  collapse = NULL,
  ...
)
}
\arguments{
\item{tbl}{A data frame}

\item{output}{Output column to be created as string or symbol.}

\item{input}{Input column that gets split as string or symbol.

The output/input arguments are passed by expression and support
\link[rlang]{quasiquotation}; you can unquote strings and symbols.}

\item{n}{The number of words in the n-gram. This must be an integer greater
than or equal to 1.}

\item{n_min}{This must be an integer greater than or equal to 1, and less
than or equal to \code{n}.}

\item{ngram_delim}{The separator between words in an n-gram.}

\item{format}{Either "text", "man", "latex", "html", or "xml". If not text,
this uses the hunspell tokenizer, and can tokenize only by "word"}

\item{to_lower}{Whether to convert tokens to lowercase. If tokens include
URLS (such as with \code{token = "tweets"}), such converted URLs may no
longer be correct.}

\item{drop}{Whether original input column should get dropped. Ignored
if the original input and new output column have the same name.}

\item{collapse}{Whether to combine text with newlines first in case tokens
(such as sentences or paragraphs) span multiple lines. If NULL, collapses
when token method is "ngrams", "skip_ngrams", "sentences", "lines",
"paragraphs", or "regex".}

\item{...}{Extra arguments passed on to \link[tokenizers]{tokenizers}}

\item{k}{For the skip n-gram tokenizer, the maximum skip distance between
words. The function will compute all skip n-grams between \code{0} and
\code{k}.}
}
\description{
These functions are wrappers around \code{unnest_tokens( token = "ngrams" )}
and \code{unnest_tokens( token = "skip_ngrams" )} .
}
\examples{
library(dplyr)
library(janeaustenr)

d <- tibble(txt = prideprejudice)

d \%>\%
  unnest_ngrams(word, txt, n = 2)

d \%>\%
  unnest_skip_ngrams(word, txt, n = 3, k = 1)

}
\seealso{
\itemize{
\item \code{\link[=unnest_tokens]{unnest_tokens()}}
}
}
