% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest.R
\name{nest.}
\alias{nest.}
\title{Nest data.tables}
\usage{
nest.(.df, ..., .names_sep = NULL)
}
\arguments{
\item{.df}{A data.table or data.frame}

\item{...}{Columns to be nested.}

\item{.names_sep}{If NULL, the names will be left alone. If a string,
the names of the columns will be created by pasting together the inner
column names and the outer column names.}
}
\description{
Nest data.tables
}
\examples{
test_df <- data.table(
  a = 1:10,
  b = 11:20,
  c = c(rep("a", 6), rep("b", 4)),
  d = c(rep("a", 4), rep("b", 6))
)

test_df \%>\%
  nest.(data = c(a, b))

test_df \%>\%
  nest.(data = where(is.numeric))
}
