% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_na.R
\name{replace_na.}
\alias{replace_na.}
\title{Replace missing values}
\usage{
replace_na.(.x, replace = NA)
}
\arguments{
\item{.x}{A data.frame/data.table or a vector}

\item{replace}{If \code{.x} is a data frame, a \code{list()} of replacement values for specified columns.
If \code{.x} is a vector, a single replacement value.}
}
\description{
Replace NAs with specified values
}
\examples{
test_df <- data.table(
  x = c(1, 2, NA),
  y = c(NA, 1, 2))

# Using replace_na.() inside mutate()
test_df \%>\%
  mutate.(x = replace_na.(x, 5))

# Using replace_na.() on a data frame
test_df \%>\%
  replace_na.(list(x = 5, y = 0))
}
