% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/purrr.R
\name{dt_map}
\alias{dt_map}
\alias{dt_map_lgl}
\alias{dt_map_int}
\alias{dt_map_dbl}
\alias{dt_map_chr}
\alias{dt_map_dfc}
\alias{dt_map_dfr}
\alias{dt_walk}
\alias{dt_map2}
\alias{dt_map2_lgl}
\alias{dt_map2_int}
\alias{dt_map2_dbl}
\alias{dt_map2_chr}
\alias{dt_map2_dfc}
\alias{dt_map2_dfr}
\title{Apply a function to each element of a vector}
\usage{


dt_map_lgl(.x, .f, ...)

dt_map_int(.x, .f, ...)

dt_map_dbl(.x, .f, ...)

dt_map_chr(.x, .f, ...)

dt_map_dfc(.x, .f, ...)

dt_map_dfr(.x, .f, ..., .id = NULL)

dt_walk(.x, .f, ...)

dt_map2(.x, .y, .f, ...)

dt_map2_lgl(.x, .y, .f, ...)

dt_map2_int(.x, .y, .f, ...)

dt_map2_dbl(.x, .y, .f, ...)

dt_map2_chr(.x, .y, .f, ...)

dt_map2_dfc(.x, .y, .f, ...)

dt_map2_dfr(.x, .y, .f, ..., .id = NULL)
}
\arguments{
\item{.x}{A list or vector}

\item{.f}{A function}

\item{...}{Other arguments to pass to a function}

\item{.id}{Whether \code{dt_map_dfr()} should add an id column to the finished dataset}

\item{.y}{A list or vector}
}
\description{
The dt_map functions transform their input by applying a function to each element and returning a vector the same length as the input.
\itemize{
\item \code{dt_map()} returns a list
\item \verb{_lgl()}, \verb{_int()}, \verb{_dbl()} and \verb{_chr()} variants return their specified type
\item \verb{_dfr()} & \verb{_dfc()} Return data frame results binded together
}
}
\examples{
dt_map(c(1,2,3), ~.x + 1)

dt_map_dbl(c(1,2,3), ~.x + 1)

dt_map_chr(c(1,2,3), as.character)
}
