% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest.R
\name{nest.}
\alias{nest.}
\title{Nest columns into a list-column}
\usage{
nest.(.df, ..., .by = NULL, .key = NULL, .names_sep = NULL)
}
\arguments{
\item{.df}{A data.table or data.frame}

\item{...}{Columns to be nested.}

\item{.by}{Columns to nest by}

\item{.key}{New column name if \code{.by} is used}

\item{.names_sep}{If NULL, the names will be left alone. If a string,
the names of the columns will be created by pasting together the inner
column names and the outer column names.}
}
\description{
Nest columns into a list-column
}
\examples{
df <- data.table(
  a = 1:3,
  b = 1:3,
  c = c("a", "a", "b"),
  d = c("a", "a", "b")
)

df \%>\%
  nest(data = c(a, b))

df \%>\%
  nest(data = where(is.numeric))

df \%>\%
  nest(.by = c(c, d))
}
\keyword{internal}
