% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/if-else2.R
\name{if_else2}
\alias{if_else2}
\title{Vectorised if else.}
\usage{
if_else2(condition, true, false)
}
\arguments{
\item{condition}{Logical vector}

\item{true, false}{Values to use for \code{TRUE} and \code{FALSE} values of
\code{condition}. They must be either the same length as \code{condition},
or length 1. They must also be the same type: \code{if_else()} checks that
they have the same type and same class. All other attributes are
taken from \code{true}.}
}
\value{
Where condition is \code{TRUE}, the matching value from \code{true}, where it's \code{FALSE} or \code{NA}, the matching value from \code{false}.
}
\description{
Vectorised if else that if true returns first possibility otherwise returns
second possibility (even if the condition is a missing value).
When searching character vectors an alternative solution is to use
\code{\link[=str_detect2]{str_detect2()}}.
}
\examples{
# consider the following data frame
data <- tibble::tibble(
  x = c(TRUE, FALSE, NA), 
  y = c("x is false", NA, "hello"))
  
# with a single vector if_else2() behaves the same as the default call to if_else().
dplyr::mutate(data,
    y1 = dplyr::if_else(y != "x is false", "x is true", y),
    y2 = if_else2(y != "x is false", "x is true", y))

# however in the case of a second vector the use of 
# if_else2() does not introduce missing values
dplyr::mutate(data,
    x1 = dplyr::if_else(stringr::str_detect(y, "x is false"), FALSE, x),
    x2 = if_else2(stringr::str_detect(y, "x is false"), FALSE, x))
    
# in the case of regular expression matching an alternative is to use 
# str_detect2()
dplyr::mutate(data,
    x3 = dplyr::if_else(str_detect2(y, "x is false"), FALSE, x))
}
\seealso{
\code{\link[=ifelse]{ifelse()}} and \code{\link[dplyr:if_else]{dplyr::if_else()}}.
}
