% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels.R
\name{sort_x_axis_labels}
\alias{sort_x_axis_labels}
\alias{sort_y_axis_labels}
\alias{sort_color_labels}
\title{Sort axis or color labels}
\usage{
sort_x_axis_labels(plot, ..., .fun = NULL, .reverse = FALSE)

sort_y_axis_labels(plot, ..., .fun = NULL, .reverse = FALSE)

sort_color_labels(plot, ..., .fun = NULL, .reverse = FALSE)
}
\arguments{
\item{plot}{A \code{tidyplot} generated with the function \code{tidyplot()}.}

\item{...}{Optional variables to use for sorting.}

\item{.fun}{Override the function used for sorting. Is automatically determined from the plot.}

\item{.reverse}{Whether the order should be reversed or not. Defaults to \code{FALSE}, meaning not reversed.}
}
\value{
A \code{tidyplot} object.
}
\description{
Sort axis or color labels
}
\examples{
# Before adjustments
study |>
  tidyplot(x = treatment, y = score) |>
  add_data_points() |>
  add_mean_bar(alpha = 0.4) |>
  add_sem_errorbar()

# Sort x-axis labels by score
study |>
  tidyplot(x = treatment, y = score) |>
  add_data_points() |>
  add_mean_bar(alpha = 0.4) |>
  add_sem_errorbar() |>
  sort_x_axis_labels()

# Before adjustments
study |>
  tidyplot(x = score, y = treatment) |>
  add_data_points() |>
  add_mean_bar(alpha = 0.4) |>
  add_sem_errorbar()

# Sort y-axis labels by score
study |>
  tidyplot(x = score, y = treatment) |>
  add_data_points() |>
  add_mean_bar(alpha = 0.4) |>
  add_sem_errorbar() |>
  sort_y_axis_labels()

# Before adjustment
study |>
  tidyplot(x = group, y = score, color = treatment) |>
  add_data_points() |>
  add_mean_bar(alpha = 0.4) |>
  add_sem_errorbar()

# Sort color labels by score
study |>
  tidyplot(x = group, y = score, color = treatment) |>
  add_data_points() |>
  add_mean_bar(alpha = 0.4) |>
  add_sem_errorbar() |>
  sort_color_labels()

}
