% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{api_parameter_reference}
\alias{api_parameter_reference}
\title{Geocoder service API parameter reference}
\format{
A tibble dataframe
\describe{
 \item{method}{Geocoder service name}
 \item{generic_name}{Universal parameter name}
 \item{api_name}{Name of the parameter for the specified geocoder service}
 \item{default_value}{Default value of the parameter}
 \item{required}{Is the parameter required by the specified geocoder service?}
}
}
\source{
Links to API documentation for each geocoder service are below.
\itemize{ 
 \item \href{https://www.census.gov/programs-surveys/geography/technical-documentation/complete-technical-documentation/census-geocoder.html}{Census}
 \item \href{https://nominatim.org/release-docs/develop/api/Search/}{Nominatim} ("osm")
 \item \href{https://www.geocod.io/docs/}{Geocodio}
 \item \href{https://locationiq.com/docs}{Location IQ} ("iq") 
 \item \href{https://developers.google.com/maps/documentation/geocoding/overview}{Google}
}
}
\usage{
api_parameter_reference
}
\description{
This dataset contains the mapping that allows this package to use a 
universal syntax to specify parameters for different geocoder services. 

The \code{generic_name} field is a universal field name while the \code{api_name}
field shows the specific parameter name for the given geocoder service (\code{method}).
When the \code{api_name} is missing this means that the parameter is not 
supported by the given geocoder service. When \code{generic_name} is missing 
this means the parameter is specific to that geocoding service.
 
Reference the documentation for \code{\link{geo}} for more information. 
Also reference \code{vignette("tidygeocoder")} for more details on constructing API queries.
}
\seealso{
\code{\link{get_api_query}} \code{\link{query_api}} \code{\link{geo}} \code{\link{geocode}}
}
\keyword{datasets}
