% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_data_wrds_compustat.R
\name{download_data_wrds_compustat}
\alias{download_data_wrds_compustat}
\title{Download Data from WRDS Compustat}
\usage{
download_data_wrds_compustat(
  type,
  start_date = NULL,
  end_date = NULL,
  additional_columns = NULL
)
}
\arguments{
\item{type}{The type of financial data to download.}

\item{start_date}{Optional. A character string or Date object in "YYYY-MM-DD" format
specifying the start date for the data. If not provided, a subset of the dataset is returned.}

\item{end_date}{Optional. A character string or Date object in "YYYY-MM-DD" format
specifying the end date for the data. If not provided, a subset of the dataset is returned.}

\item{additional_columns}{Additional columns from the Compustat table
as a character vector.}
}
\value{
A data frame with financial data for the specified period, including
variables for book equity (be), operating profitability (op), investment
(inv), and others.
}
\description{
This function downloads financial data from the WRDS Compustat database for a
given type of financial data, start date, and end date. It filters the data
according to industry format, data format, and consolidation level, and
returns the most current data for each reporting period. Additionally, the
annual data also includes the calculated calculates book equity (be),
operating profitability (op), and investment (inv) for each company.
}
\examples{
\donttest{
  download_data_wrds_compustat("wrds_compustat_annual", "2020-01-01", "2020-12-31")
  download_data_wrds_compustat("wrds_compustat_quarterly", "2020-01-01", "2020-12-31")

  # Add additional columns
  download_data_wrds_compustat("wrds_compustat_annual", additional_columns = c("aodo", "aldo"))
}
}
