% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{visualize_graph}
\alias{visualize_graph}
\title{Visualize the CWL workflow}
\usage{
visualize_graph(
  g,
  hierarchical = TRUE,
  direction = "LR",
  separation = 300,
  palette = c("#C3C3C3", "#FF8F00", "#00AAA8"),
  width = "100\%",
  height = 600
)
}
\arguments{
\item{g}{Graph generated by \code{\link{get_graph}}.}

\item{hierarchical}{Enable the hierarchical layout? Default is \code{TRUE}.}

\item{direction}{Direction of the hierarchical layout.
Options include \code{"LR"}, \code{"RL"}, \code{"UD"}, and \code{"DU"}
(up-down, down-up, left-right, right-left). Default is \code{"LR"}.}

\item{separation}{Level separation parameter from
\code{\link[visNetwork]{visHierarchicalLayout}}.}

\item{palette}{Three-color palette for inputs, outputs, and steps.}

\item{width}{Canvas width, see \code{\link[visNetwork]{visNetwork}}.
Default is \code{"100\%"}.}

\item{height}{Canvas height, see \code{\link[visNetwork]{visNetwork}}.
Default is \code{600}.}
}
\value{
A \code{\link[visNetwork]{visNetwork}} output.
}
\description{
Visualize the CWL workflow
}
\examples{
flow <- system.file("cwl/sbg/workflow/gatk4-wgs.json", package = "tidycwl") \%>\% read_cwl_json()
get_graph(
  flow \%>\% parse_inputs(),
  flow \%>\% parse_outputs(),
  flow \%>\% parse_steps()
) \%>\% visualize_graph()
}
