% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crr.R
\name{crr}
\alias{crr}
\alias{crr.formula}
\alias{crr.default}
\title{Competing Risks Regression}
\usage{
\method{crr}{formula}(formula, data, failcode = NULL, ...)

crr(x, ...)

\method{crr}{default}(x, ...)
}
\arguments{
\item{formula}{formula with \code{Surv()} on LHS and covariates on RHS.
The event status variable must be a factor, with the first level indicating
'censor' and subsequent levels the competing risks.}

\item{data}{data frame}

\item{failcode}{Indicates event of interest. If \verb{failcode=} is \code{NULL},
the first competing event will be used as the event of interest.
Default is \code{NULL}.}

\item{...}{passed to methods}

\item{x}{input object}
}
\value{
tidycrr object
}
\description{
Competing Risks Regression
}
\examples{
crr(Surv(ttdeath, death_cr) ~ age + grade, trial)
}
\seealso{
Other crr() functions: 
\code{\link{broom_methods_crr}},
\code{\link{predict.tidycrr}()}
}
\concept{crr() functions}
