% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_draws.R
\name{sample_draws}
\alias{sample_draws}
\title{Sample draws from a tidy-format data frame of draws}
\usage{
sample_draws(data, ndraws, draw = ".draw", seed = NULL)
}
\arguments{
\item{data}{Data frame to sample from}

\item{ndraws}{The number of draws to return, or \code{NULL} to return all draws.}

\item{draw}{The name of the column indexing the draws; default \code{".draw"}.}

\item{seed}{A seed to use when subsampling draws (i.e. when \code{ndraws} is not \code{NULL}).}
}
\description{
Given a tidy-format data frame of draws with a column indexing each draw, subsample the data frame to a given size
based on a column indexing draws, ensuring that rows in sub-groups of a grouped data frame are sampled from the
same draws.
}
\details{
\code{sample_draws()} makes it easier to sub-sample a grouped, tidy-format data frame of draws. On a grouped data frame,
the naive approach of using \code{filter} with the \code{.draw} column will give incorrect results as it will
select a different sample within each group. \code{sample_draws()} ensures the same sample is selected within
each group.
}
\examples{
\dontshow{if (requireNamespace("brms", quietly = TRUE) && requireNamespace("modelr", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{

library(ggplot2)
library(dplyr)
library(brms)
library(modelr)

theme_set(theme_light())

m_mpg = brm(mpg ~ hp * cyl, data = mtcars,
  # 1 chain / few iterations just so example runs quickly
  # do not use in practice
  chains = 1, iter = 500)

# draw 100 fit lines from the posterior and overplot them
mtcars \%>\%
  group_by(cyl) \%>\%
  data_grid(hp = seq_range(hp, n = 101)) \%>\%
  add_epred_draws(m_mpg) \%>\%
  # NOTE: only use sample_draws here when making spaghetti plots; for
  # plotting intervals it is always best to use all draws
  sample_draws(100) \%>\%
  ggplot(aes(x = hp, y = mpg, color = ordered(cyl))) +
  geom_line(aes(y = .epred, group = paste(cyl, .draw)), alpha = 0.25) +
  geom_point(data = mtcars)

}
\dontshow{\}) # examplesIf}
}
\author{
Matthew Kay
}
\keyword{manip}
