% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_eye.R
\name{geom_eye}
\alias{geom_eye}
\alias{geom_eyeh}
\alias{geom_halfeyeh}
\title{Eye plots of densities with point and interval summaries (Deprecated spellings)}
\usage{
geom_eye(..., scale = 0.9, .width = c(0.66, 0.95), relative_scale, .prob)

geom_eyeh(..., scale = 0.9, .width = c(0.66, 0.95), relative_scale, .prob)

geom_halfeyeh(..., scale = 0.9, .width = c(0.66, 0.95), relative_scale, .prob)
}
\arguments{
\item{...}{Arguments passed to \code{\link[=stat_sample_slabinterval]{stat_sample_slabinterval()}}}

\item{scale}{What proportion of the region allocated to this geom to use to draw the slab. If \code{scale = 1},
slabs that use the maximum range will just touch each other. Default is \code{0.9} to leave some space.}

\item{.width}{The \code{.width} argument passed to \code{interval_function} or \code{point_interval}.}

\item{relative_scale}{Deprecated. Use \code{scale} instead.}

\item{.prob}{Deprecated. Use \code{.width} instead.}
}
\description{
These are deprecated spellings of \code{\link[=stat_eye]{stat_eye()}}, \code{\link[=stat_eyeh]{stat_eyeh()}},
and \code{\link[=stat_halfeyeh]{stat_halfeyeh()}}. Use those functions instead.
}
\examples{

library(magrittr)
library(ggplot2)

data(RankCorr, package = "tidybayes")

RankCorr \%>\%
  spread_draws(u_tau[i]) \%>\%
  ggplot(aes(y = i, x = u_tau)) +
  geom_eyeh()

RankCorr \%>\%
  spread_draws(u_tau[i]) \%>\%
  ggplot(aes(x = i, y = u_tau)) +
  geom_eye()

}
\seealso{
See \code{\link[=stat_sample_slabinterval]{stat_sample_slabinterval()}} and the shortcut stats documented there for the
preferred way to generate these geoms.
}
\author{
Matthew Kay
}
